/**
 * @license Copyright (c) Microsoft Corporation. All rights reserved.
 */

var Storage = {};

Storage.setItem = function(key, value) {
	try {
		sessionStorage.setItem(key, value);
	} catch(error) {
		throw Error("Failed to set sessionStorage item with key '" + key + "'. Reason = " + error.message);
	}
}

Storage.getItem = function(key) {
	try {
		return sessionStorage.getItem(key);
	} catch(error) {
		throw Error("Failed to get sessionStorage item with key '" + key + "'. Reason = " + error.message);
	}
}

const STORAGE_ITEM = {
	clientId: "clientId",
	scope: "scope",
	redirectUri: "redirectUri",
	sessionId: "sessionId",
	projectKey: "projectKey",
	collectorUri: "collectorUri",
	installId: "installId",
	tenantId: "tenantId",
};

const hashParams = Helper.hashToObject(window.location.hash);

if (hashParams) {
	if (hashParams[STORAGE_ITEM.clientId]) 
		Storage.setItem(STORAGE_ITEM.clientId, hashParams.clientId);
	if (hashParams[STORAGE_ITEM.scope]) 
		Storage.setItem(STORAGE_ITEM.scope, hashParams.scope);
	if (hashParams[STORAGE_ITEM.redirectUri]) 
		Storage.setItem(STORAGE_ITEM.redirectUri, hashParams.redirectUri);
	if (hashParams[STORAGE_ITEM.sessionId]) 
		Storage.setItem(STORAGE_ITEM.sessionId, hashParams.sessionId);
	if (hashParams[STORAGE_ITEM.projectKey]) 
		Storage.setItem(STORAGE_ITEM.projectKey, hashParams.projectKey);
	if (hashParams[STORAGE_ITEM.collectorUri]) 
		Storage.setItem(STORAGE_ITEM.collectorUri, hashParams.collectorUri);
	if (hashParams[STORAGE_ITEM.installId])
		Storage.setItem(STORAGE_ITEM.installId, hashParams.installId);
	if (hashParams[STORAGE_ITEM.tenantId])
		Storage.setItem(STORAGE_ITEM.tenantId, hashParams.tenantId);
}